/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.IntSeq;
import org.basex.util.list.IntList;

public final class BinToOctets
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return BinToOctets.toIter(this.toBin(this.arg(0), qc).binary(this.info));
    }

    public static BasicIter<Itr> toIter(final byte[] bytes) {
        return new BasicIter<Itr>((long)bytes.length){

            @Override
            public Itr get(long i) {
                return Itr.get(bytes[(int)i] & 0xFF);
            }

            @Override
            public Value value(QueryContext q, Expr expr) {
                int bl = bytes.length;
                if (bl == 1) {
                    return this.get(0L);
                }
                IntList list = new IntList(bl);
                for (byte b : bytes) {
                    list.add(b & 0xFF);
                }
                return IntSeq.get(list.finish());
            }
        };
    }
}

