/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class FNSpace
extends FNode {
    private final byte[] name;
    private final byte[] value;

    public FNSpace(byte[] name, byte[] value) {
        super(NodeType.NAMESPACE_NODE);
        this.name = name;
        this.value = value;
    }

    @Override
    public QNm qname() {
        return new QNm(this.name);
    }

    @Override
    public byte[] name() {
        return this.name;
    }

    @Override
    public byte[] string() {
        return this.value;
    }

    @Override
    public FNSpace materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) {
        return this.materialized(test, ii) ? this : new FNSpace(this.name, this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FNSpace)) return false;
        FNSpace f = (FNSpace)obj;
        if (!Token.eq(this.name, f.name)) return false;
        if (!Token.eq(this.value, f.value)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name, "value", this.value), new ExprInfo[0]);
    }

    @Override
    public void toString(QueryString qs) {
        TokenBuilder tb = new TokenBuilder().add(Token.XMLNS);
        if (this.name.length != 0) {
            tb.add(58).add(this.name);
        }
        tb.add(61).add(QueryString.toQuoted(this.value));
        qs.token(tb.finish());
    }
}

