/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;

public final class ArrayItems
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.toArray(this.arg(0), qc).itemsIter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.toArray(this.arg(0), qc).items(qc);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr array = this.arg(0);
        Type type = array.seqType().type;
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            SeqType vt = at.valueType();
            this.exprType.assign(vt.with(Occ.ZERO_OR_MORE), vt.one() ? array.structSize() : -1L);
        }
        return this;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr array = this.arg(0);
        ArrayItems expr = mode.oneOf(CompileContext.Simplify.STRING, CompileContext.Simplify.NUMBER, CompileContext.Simplify.DATA) && array.seqType().type instanceof ArrayType ? array : this;
        return cc.simplify(this, expr, mode);
    }
}

