/*
 *  Copyright (C) 2010 Ryszard Wiśniewski <brut.alll@gmail.com>
 *  Copyright (C) 2010 Connor Tumbleson <connor.tumbleson@gmail.com>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.RawXmlEncounteredException;
import brut.androlib.res.xml.ResXmlSerializer;
import brut.xmlpull.XmlPullUtils;
import org.xmlpull.v1.XmlPullParserException;

import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ResXmlPullStreamDecoder implements ResStreamDecoder {
    private final BinaryXmlResourceParser mParser;
    private final ResXmlSerializer mSerial;
    private final XmlPullUtils.EventHandler mHandler;

    public ResXmlPullStreamDecoder(BinaryXmlResourceParser parser, ResXmlSerializer serial) {
        this(parser, serial, null);
    }

    public ResXmlPullStreamDecoder(BinaryXmlResourceParser parser, ResXmlSerializer serial,
                                   XmlPullUtils.EventHandler handler) {
        mParser = parser;
        mSerial = serial;
        mHandler = handler;
    }

    @Override
    public void decode(InputStream in, OutputStream out) throws AndrolibException {
        try {
            mParser.setInput(in, null);
            mSerial.setOutput(out, null);
            XmlPullUtils.copy(mParser, mSerial, mHandler);
        } catch (XmlPullParserException ex) {
            throw new RawXmlEncounteredException(ex);
        } catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }
}
